/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.data.saved;

import com.redpxnda.respawnobelisks.network.ModPackets;
import com.redpxnda.respawnobelisks.network.RespawnAnchorInteractionPacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class AnchorExplosion {
    private final int delay;
    private int tick;
    private final BlockPos pos;
    private final int charge;
    public boolean stopped = false;

    public AnchorExplosion(int tick, int delay, int charge, BlockPos pos) {
        this.tick = tick;
        this.delay = delay;
        this.pos = pos;
        this.charge = charge;
    }

    public AABB getAABB() {
        return AABB.m_82321_((BoundingBox)new BoundingBox(this.pos.m_123341_() - 10, this.pos.m_123342_() - 10, this.pos.m_123343_() - 10, this.pos.m_123341_() + 10, this.pos.m_123342_() + 10, this.pos.m_123343_() + 10));
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("Tick", this.tick);
        tag.m_128405_("Delay", this.delay);
        tag.m_128405_("Charge", this.charge);
        tag.m_128385_("Pos", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
        return tag;
    }

    public static AnchorExplosion fromNbt(CompoundTag tag) {
        int[] intArray = tag.m_128465_("Pos");
        BlockPos blockPos = new BlockPos(intArray[0], intArray[1], intArray[2]);
        return new AnchorExplosion(tag.m_128451_("Tick"), tag.m_128451_("Delay"), tag.m_128451_("Charge"), blockPos);
    }

    public void tick(ServerLevel level) {
        if (this.tick++ >= this.delay) {
            this.stopped = true;
            this.execute(level);
        } else if (this.tick % 10 == 0) {
            List players = level.m_8795_(p -> this.getAABB().m_82393_(p.m_20185_(), p.m_20186_(), p.m_20189_()));
            ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new RespawnAnchorInteractionPacket(this.pos, false, this.charge));
        }
    }

    public void execute(ServerLevel level) {
        level.m_7731_(this.pos, Blocks.f_50016_.m_49966_(), 3);
        List players = level.m_8795_(p -> this.getAABB().m_82393_(p.m_20185_(), p.m_20186_(), p.m_20189_()));
        ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new RespawnAnchorInteractionPacket(this.pos, true, this.charge));
        level.m_7703_(null, DamageSource.m_19334_(), null, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_(), (double)this.pos.m_123343_() + 0.5, (float)(5 + 2 * this.charge), true, Explosion.BlockInteraction.DESTROY);
    }

    public String toString() {
        return "AnchorExplosion{delay=" + this.delay + ", tick=" + this.tick + ", pos=" + this.pos + ", charge=" + this.charge + ", stopped=" + this.stopped + "}";
    }
}

